'use strict';
angular.module('Resources', ['ngResource']).
    factory('StructureResource', function($resource){
        return  $resource( vDataPath + '/structure.json',{}, {
            query: {
                method: "GET"
            }
        });
    })
    .factory('PageResource', function($resource){
        return  $resource('/data/pages/:page',{},{
                query: {
                    method: "GET"
                    ,transformResponse: function(data){
                        var sourceData = angular.fromJson(data);
                        return new MbPage(sourceData);
                    }
                }
            }
        );
    })
    .factory('TaskResource', function($resource){
        return  $resource(debugModeUrl + '/data/:page',{},{
                query: {
                    method: "GET"
                    ,transformResponse: function(data){
                        var sourceData = angular.fromJson(data);
                        console.log(sourceData);
                        return new TaskObject(sourceData);
                    }
                }
            }
        );
    })
;